ServerEvents.recipes((event) => {
  //MI Forge hammer additions
  event
    .custom({
      type: "modern_industrialization:forge_hammer",
      ingredient: {
        tag: "minecraft:logs",
      },
      result: {
        count: 1,
        id: "mekanism:sawdust",
      },
    })
    .id("ftb:forge_hammer_logs");

  //Enriched carbon from geode
  event
    .custom({
      type: "mekanism:enriching",
      input: { count: 1, tag: "geore:coal_shard" },
      output: { count: 1, id: "mekanism:enriched_carbon" },
    })
    .id("ftb:enriched_carbon_geode");

  //Prosperity
  event
    .custom({
      type: "mekanism:enriching",
      input: { count: 1, tag: "jaopca:mekanism_dirty_dusts.prosperity" },
      output: { count: 1, id: "mysticalagriculture:prosperity_shard" },
    })
    .id("ftb:prosperity_shard");

  //additional
  Ingredient.of("#minecraft:leaves").stacks.forEach((item) => {
    var itemName = item.id.replace(":", "_");
    event
      .custom({
        type: "mekanism:crushing",
        input: { count: 1, item: item.id },
        output: { count: 2, id: "mekanism:bio_fuel" },
      })
      .id(`ftb:biocrushing_${itemName}`);
  });

  // Biofuel
  event
    .custom({
      type: "mekanism:crushing",
      input: { count: 1, item: "xycraft_machines:resin_ball" },
      output: { count: 9, id: "mekanism:bio_fuel" },
    })
    .id(`ftb:biocrushing_resin`);
});
